IF NOT OBJECT_ID('UFD_RETORNA_ENVIO_GESTOR_TRIBUTARIO') IS NULL
BEGIN
	DROP FUNCTION UFD_RETORNA_ENVIO_GESTOR_TRIBUTARIO
END

GO

CREATE FUNCTION
	UFD_RETORNA_ENVIO_GESTOR_TRIBUTARIO (@CD_REGIAO_FISCAL INT, @CD_PROD VARCHAR(8000), @CFOP VARCHAR(8000))
RETURNS
	@RS_RESULT TABLE (
		CD_CTR BIGINT,
		CD_REGIAO_FISCAL INT,
		TP_AMBIENTE INT,
		CNPJ VARCHAR(50),
		CRT INT,
		REGIME_TRIB VARCHAR(2),
		INDIE INT,
		UF VARCHAR(2),
		CNAE VARCHAR(100),
		CFOP VARCHAR(50),
		FINALIDADE INT,
		SIMPLES_NACIONAL VARCHAR(2),
		ORIGEM INT,
		SUBST_ICMS VARCHAR(2))
BEGIN

DECLARE @CFOP_TABLE TABLE (
	CD_NT_OP INT)

IF @CFOP = '' 
BEGIN
	INSERT INTO @CFOP_TABLE SELECT CD_NT_OP FROM GLB_NT_OP WHERE FLAG_NAO_ENVIA_GT = 0
END ELSE
BEGIN
	INSERT INTO @CFOP_TABLE SELECT ID FROM UFD_PRM_IN_STRING(@CFOP)
END

INSERT INTO
	@RS_RESULT
SELECT
	1 AS CD_CTR
	, REGIAO.CD_REGIAO_FISCAL
	, 1 AS TP_AMBIENTE
	, REPLACE(REPLACE(REPLACE(FILIAL.CGC, '.', ''), '-', ''), '/','') AS CNPJ
	, CASE REGIAO.TIPO_REGIME_EMPRESA
		WHEN 1 THEN 1
		WHEN 2 THEN 2
		ELSE 3
	END AS CRT
	, CASE REGIAO.TIPO_REGIME_EMPRESA 
		WHEN 1 THEN 'NA'
		WHEN 2 THEN 'NA'
		WHEN 3 THEN 'LP'
		WHEN 4 THEN 'LR'
		ELSE 'LR'
	END AS REGIME_TRIB
	, 1 AS INDIE
	, CIDADE.UF
	, FILIAL.CNAE
	, REPLACE(CFOP.CD_NT_OP_FC, '.', '') AS CFOP
	, 0 AS FINALIDADE
	, SIMPLES_NACIONAL.SIMPLES_NACIONAL
	, ORIGEM_PRODUTOS.ORIGEM_PRODUTO AS ORIGEM
	, 'N' AS SUBST_ICMS

FROM
	PRC_REGIAO_FISCAL REGIAO
	INNER JOIN (
		SELECT
			CD_REGIAO_FISCAL,
			MIN(CD_FILIAL) AS CD_FILIAL
		FROM
			PRC_REGIAO_FISCAL_PRC_FILIAL
		GROUP BY
			CD_REGIAO_FISCAL) REGIAO_FILIAL ON
		REGIAO.CD_REGIAO_FISCAL = REGIAO_FILIAL.CD_REGIAO_FISCAL
	INNER JOIN PRC_FILIAL FILIAL ON
		REGIAO_FILIAL.CD_FILIAL = FILIAL.CD_FILIAL
	INNER JOIN GLB_CID CIDADE ON
		FILIAL.CD_CID = CIDADE.CD_CID
	INNER JOIN GLB_NT_OP CFOP ON
		1 = 1
		AND FLAG_NAO_ENVIA_GT = 0
		AND CD_NT_OP IN (SELECT CD_NT_OP FROM @CFOP_TABLE)
		--criterio s pra pegar sada dentro do estado da empresa de origem
		AND LEFT(CFOP.CD_NT_OP_FC, 1) = '5'
	INNER JOIN GLB_NT_OP_PROD CFOP_OP ON
		RIGHT(CFOP.CD_NT_OP_FC, 3) = CAST(CFOP_OP.NR_CFOP_PROD AS VARCHAR(10)) COLLATE SQL_Latin1_General_CP1_CI_AS
		AND CFOP_OP.ORIG_DEST IN (0 ,3)
		AND CFOP_OP.TP_MOV_OP_TRANSA IN (0, 2)
		AND CFOP_OP.STS = 0
	INNER JOIN (
		SELECT
			'N' AS SIMPLES_NACIONAL
		UNION
		SELECT
			'S' AS SIMPLES_NACIONAL) SIMPLES_NACIONAL ON
		1 = 1
	INNER JOIN (
		SELECT
			ORIGEM_PRODUTO
		FROM
			EST_PROD
		WHERE
			CD_EMP = 1
			AND CD_PROD IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_PROD))
		GROUP BY
			ORIGEM_PRODUTO) ORIGEM_PRODUTOS ON
		1 = 1
WHERE
	REGIAO.CD_REGIAO_FISCAL = CASE WHEN @CD_REGIAO_FISCAL = 0 THEN REGIAO.CD_REGIAO_FISCAL ELSE @CD_REGIAO_FISCAL END
ORDER BY
	REGIAO.CD_REGIAO_FISCAL,
	REPLACE(CFOP.CD_NT_OP_FC, '.', '')

RETURN

END